document.addEventListener('click', function (e) {
  if (!e.ctrlKey) return;

  e.preventDefault();
  e.stopPropagation();

  let text = '';
  let el = document.elementFromPoint(e.clientX, e.clientY);

  if (el) {
    if (el.nodeType === Node.TEXT_NODE) {
      text = el.textContent;
    } else if (el instanceof HTMLElement) {
      text = el.innerText || el.textContent || '';
    }
  }

  if (!text) return;

  const regex = /[\w\-.]+/g;

  const range = document.caretRangeFromPoint(e.clientX, e.clientY);
  if (!range) return;

  const offset = range.startOffset;

  let match;
  let copiedWord = null;

  while ((match = regex.exec(text)) !== null) {
    if (offset >= match.index && offset <= match.index + match[0].length) {
      copiedWord = match[0];
      break;
    }
  }

  if (!copiedWord && text.trim().length > 0) {
    copiedWord = text.trim();
  }

  if (copiedWord) {
    navigator.clipboard.writeText(copiedWord).then(() => {
      showPopup(`Copied: ${copiedWord}`);
    });
  }
});

function showPopup(message) {
  const popup = document.createElement('div');
  popup.className = 'easy-copy-popup';
  popup.textContent = message;
  document.body.appendChild(popup);
  setTimeout(() => {
    popup.remove();
  }, 1500);
}
